import React, { memo } from 'react';
import { shell } from 'electron';
import cn from 'classnames';
import SlidingFooter from 'components/SlidingFooter';
import {
    CARDO_FACEBOOK_URL,
    CARDO_INSTAGRAM_URL,
    CARDO_YOUTUBE_URL,
    CARDO_TWITTER_URL,
    JBL_BETTER_SOUND_URL,
    SUPPORT_URL,
    TERRANO_SUPPORT_URL
} from 'constants/urls';
import { MODELS } from 'library/headset/consts';
import jblIcon from 'resources/images/jbl.svg';
import facebookIcon from 'resources/images/facebook.svg';
import instagramIcon from 'resources/images/instagram.svg';
import youtubeIcon from 'resources/images/youtube.svg';
import twitterIcon from 'resources/images/twitter.svg';
import useStyles from './styles';

type Props = {
    strings: object,
    device: object,
    language: string
};

function Footer({ strings, device, language }: Props) {
    const classes = useStyles();
    return (
        <div className={classes.footerContainer}>
            <SlidingFooter
                slidingTime={8000}
                animationTime={1000}
                className={classes.footer}
                language={language}
            >
                <div className={classes.footerItem}>
                    <div
                        onClick={() => shell.openExternal(JBL_BETTER_SOUND_URL)}
                        className={classes.footerBetterSoundContainer}
                    >
                        <img
                            className={classes.betterSoundIcon}
                            src={jblIcon}
                            alt="JBL Icon"
                        />
                        <span>{strings.update_device_footer_jbl}</span>
                    </div>
                </div>
                <div
                    onClick={() =>
                        shell.openExternal(
                            device.model === MODELS.TERRANOXT
                                ? TERRANO_SUPPORT_URL
                                : SUPPORT_URL
                        )
                    }
                    className={cn(
                        classes.footerItem,
                        classes.footerNeedSupport
                    )}
                >
                    {strings.general_link_need_support}
                </div>
                <div className={classes.footerItem}>
                    <div className={classes.footerFollowContainer}>
                        <span className={classes.footerFollowContainerText}>
                            {strings.update_device_footer_follow}
                        </span>
                        <img
                            onClick={() =>
                                shell.openExternal(CARDO_FACEBOOK_URL)
                            }
                            className={classes.footerFollowIcon}
                            src={facebookIcon}
                            alt="Facebook"
                        />
                        <img
                            onClick={() =>
                                shell.openExternal(CARDO_INSTAGRAM_URL)
                            }
                            className={classes.footerFollowIcon}
                            src={instagramIcon}
                            alt="Instagram"
                        />
                        <img
                            onClick={() =>
                                shell.openExternal(CARDO_YOUTUBE_URL)
                            }
                            className={classes.footerFollowIcon}
                            src={youtubeIcon}
                            alt="Youtube"
                        />
                        <img
                            onClick={() =>
                                shell.openExternal(CARDO_TWITTER_URL)
                            }
                            className={classes.footerFollowIcon}
                            src={twitterIcon}
                            alt="Twitter"
                        />
                    </div>
                </div>
            </SlidingFooter>
        </div>
    );
}

export default memo(Footer);
